
<header id="header" class="header fixed-top d-flex align-items-center">
    <div class="d-flex align-items-center justify-content-between">
        <a href="" class="logo d-flex align-items-center">
            <img src="" alt="">
            <span class="d-none d-lg-block">Emmanuel Business</span>
        </a>
        <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->

    <div class="search-bar">
        <form class="search-form d-flex align-items-center" method="POST" action="#">
            <input type="text" name="query" placeholder="Search" title="Enter search keyword">
            <button type="submit" title="Search"><i class="bi bi-search"></i></button>
        </form>
    </div><!-- End Search Bar -->

    <nav class="header-nav ms-auto">
        <ul class="d-flex align-items-center">
            <li class="nav-item d-block d-lg-none">
                <a class="nav-link nav-icon search-bar-toggle" href="#">
                    <i class="bi bi-search"></i>
                </a>
            </li><!-- End Search Icon -->

            <li class="nav-item dropdown pe-3">
                <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
                    <img src="" alt="Profile" class="rounded-circle">
                    <span class="d-none d-md-block dropdown-toggle ps-2"></span>
                </a><!-- End Profile Image Icon -->
                <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                    <li class="dropdown-header">
                        <h6 class="user-name"></h6>
                        <span></span>
                    </li>
                    <li>
                        <hr class="dropdown-divider">
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="profile">
                            <i class="bi bi-person"></i>
                            <span>My Profile</span>
                        </a>
                    </li>
                    <li>
                        <hr class="dropdown-divider">
                    </li>
                    <li>
                        <a id="logout-link" class="dropdown-item d-flex align-items-center" href="">
                            <i class="bi bi-box-arrow-right"></i>
                            <span>Sign Out</span>
                        </a>
                    </li>
                </ul><!-- End Profile Dropdown Items -->
            </li><!-- End Profile Nav -->
        </ul>
    </nav><!-- End Icons Navigation -->
</header><!-- End Header -->

<!-- ======= Sidebar ======= -->
<aside id="sidebar" class="sidebar">

<ul class="sidebar-nav" id="sidebar-nav">

  <li class="nav-item">
    <a class="nav-link " href="home">
      <i class="bi bi-grid"></i>
      <span>Dashboard</span>
    </a>
  </li><!-- End Dashboard Nav -->

  <li class="nav-item">
  <a class="nav-link" href="report-components">
    <i class="bi bi-file-earmark-text"></i>
    <span>Report Components</span>
  </a>
</li>
<li class="nav-item">
  <a class="nav-link" href="component-assets">
    <i class="bi bi-box"></i>
    <span>Manage Assets</span>
  </a>
</li>
<li class="nav-item">
  <a class="nav-link" href="view-expense-types">
    <i class="bi bi-cash-stack"></i>
    <span>Expenses Types</span>
  </a>
</li>
<li class="nav-item">
  <a class="nav-link" href="view-expenses">
    <i class="bi bi-cash-stack"></i>
    <span>Expenses</span>
  </a>
</li>
<li class="nav-item">
  <a class="nav-link" href="view-incomes">
    <i class="bi bi-wallet2"></i>
    <span>Incomes</span>
  </a>
</li>
<li class="nav-item">
  <a class="nav-link" href="reports">
    <i class="bi bi-bar-chart-line"></i>
    <span>Reports</span>
  </a>
</li>
<li class="nav-item">
  <a class="nav-link" href="register">
    <i class="bi bi-person-plus"></i>
    <span>Register</span>
  </a>
</li>

</ul>

</aside><!-- End Sidebar-->
<script>
    document.addEventListener("DOMContentLoaded", () => {
        const user = JSON.parse(localStorage.getItem("user"));

        if (user) {
            // Set the user's name
            const userNameElement = document.querySelector(".nav-profile .dropdown-toggle");
            if (userNameElement) {
                userNameElement.textContent = user.name;
            }

            // Set the profile image or default icon
            const profileImageElement = document.querySelector(".nav-profile img");
            if (profileImageElement) {
                if (profileImageElement.getAttribute("src") === "") {
                    profileImageElement.outerHTML = `<i class="bi bi-person-circle fs-4"></i>`;
                }
            }
        }

        // Sign Out functionality
        const logoutLink = document.getElementById("logout-link");
        if (logoutLink) {
            logoutLink.addEventListener("click", (e) => {
                e.preventDefault();
                // Clear user data and token from localStorage
                localStorage.removeItem("user");
                localStorage.removeItem("token");

                // Redirect to the login page
                window.location.href = "/";

                // Clear browser history and prevent navigation
                setTimeout(() => {
                    window.location.replace("/");
                    history.pushState(null, null, window.location.href);
                    window.addEventListener("popstate", () => {
                        history.pushState(null, null, window.location.href);
                    });
                }, 0);
            });
        }
    });

    // Prevent navigation using back/forward buttons
    window.addEventListener("load", () => {
        history.pushState(null, null, window.location.href);
        window.addEventListener("popstate", () => {
            history.pushState(null, null, window.location.href);
        });
    });
</script>