@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Expenses</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Expenses</li>
            </ol>
        </nav>
    </div>

    <section class="section dashboard">
        <div class="container">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <input type="text" id="searchInput" class="form-control w-50" placeholder="Search expenses...">
                    <button class="btn btn-primary" id="createExpenseBtn">Add New Expense</button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="expensesTable">
                            <thead>
                                <tr>
                                    <th>Expense Number</th>
                                    <th>Report</th>
                                    <th>Asset</th>
                                    <th>Amount</th>
                                    <th>Type</th>
                                    <th>Created by</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Expense Modal -->
    <div class="modal fade" id="expenseModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="expenseForm" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Add Expense</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="expenseId">
                    <input type="hidden" id="userId">

                    <div class="mb-3">
                        <label class="form-label">Report</label>
                        <select id="reportId" class="form-select" required></select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Asset</label>
                        <select id="assetId" class="form-select" required></select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Amount</label>
                        <input type="number" id="amount" class="form-control" required min="0">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Expense Type</label>
                        <select id="expenseTypeId" class="form-select" required></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Save</button>
                </div>
            </form>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", () => {
    const token = localStorage.getItem("token");
    const tbody = document.querySelector("#expensesTable tbody");
    const user = JSON.parse(localStorage.getItem("user"));
    const userId = user?.user_id || null;
    const baseUrl = "{{ env('APP_URL') }}";

    const form = document.getElementById("expenseForm");

   
function fetchReports() {
        return fetch("{{ env('APP_URL') . 'api/reports'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            const reportsSelect = document.getElementById("reportId");
            reportsSelect.innerHTML = `<option value="">Select Report Number</option>`;
            data.forEach(report => {
                const option3 = document.createElement("option");
                option3.value = report.id;
                option3.text = report.report_number;
                reportsSelect.appendChild(option3);
            });
        });
    }
  

function fetchAssets() {
        return fetch("{{ env('APP_URL') . 'api/assets'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(assets => {
            const assetSelect = document.getElementById("assetId");
            assetSelect.innerHTML = `<option value="">Select Asset</option>`;
            assets.forEach(asset => {
                const option = document.createElement("option");
                option.value = asset.id;
                option.text = asset.name;
                assetSelect.appendChild(option);
            });
        });
    }
    function fetchExpenseType() {
        return fetch("{{ env('APP_URL') . 'api/expens-types'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            const typeSelect = document.getElementById("expenseTypeId");
            typeSelect.innerHTML = `<option value="">Select Expenses Type</option>`;
            data.forEach(type => {
                const option2 = document.createElement("option");
                option2.value = type.id;
                option2.text = type.name;
                typeSelect.appendChild(option2);
            });
        });
    }

  
    function fetchExpenses() {
        fetch("{{ env('APP_URL') .  'api/expenses'}}", {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            tbody.innerHTML = data.map(expense => `
                <tr>
                    <td>${expense.expense_number}</td>
                    <td>${expense.report?.report_number || '-'}</td>
                    <td>${expense.asset?.name || '-'}</td>
                    <td>${expense.amount}</td>
                    <td>${expense.expense_type?.name || '-'}</td>
                    <td>${expense.user?.name || '-'}</td>
                    <td>
                        <button class="btn btn-warning btn-sm edit-btn" data-id="${expense.id}" data-report="${expense.report_id}" data-asset="${expense.asset_id}" data-amount="${expense.amount}" data-type="${expense.expense_type_id}">Edit</button>
                        <button class="btn btn-danger btn-sm delete-btn" data-id="${expense.id}">Delete</button>
                    </td>
                </tr>
            `).join('');
        });
    }

    document.getElementById("createExpenseBtn").addEventListener("click", () => {
        form.reset();
        document.getElementById("modalTitle").textContent = "Add Expense";
        document.getElementById("expenseId").value = "";
        document.getElementById("userId").value = userId;
        new bootstrap.Modal(document.getElementById("expenseModal")).show();
    });

    tbody.addEventListener("click", e => {
        const btn = e.target;
        if (btn.classList.contains("edit-btn")) {
            const id = btn.dataset.id;
            document.getElementById("expenseId").value = id;
            document.getElementById("reportId").value = btn.dataset.report;
            document.getElementById("assetId").value = btn.dataset.asset;
            document.getElementById("amount").value = btn.dataset.amount;
            document.getElementById("expenseTypeId").value = btn.dataset.type;
            document.getElementById("modalTitle").textContent = "Edit Expense";
            new bootstrap.Modal(document.getElementById("expenseModal")).show();
        }

        if (btn.classList.contains("delete-btn")) {
            const id = btn.dataset.id;
            Swal.fire({
                title: "Delete this expense?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete it!"
            }).then((res) => {
                if (res.isConfirmed) {
                    fetch(`${baseUrl}api/expenses/${id}`, {
                        method: "DELETE",
                        headers: { "Authorization": `Bearer ${token}` }
                    }).then(() => {
                        Swal.fire("Deleted!", "Expense removed.", "success");
                        fetchExpenses();
                    });
                }
            });
        }
    });

    form.addEventListener("submit", e => {
        e.preventDefault();
        const id = document.getElementById("expenseId").value;
        const payload = {
            report_id: document.getElementById("reportId").value,
            asset_id: document.getElementById("assetId").value,
            amount: document.getElementById("amount").value,
            expense_type_id: document.getElementById("expenseTypeId").value,
            user_id: userId
        };

        const url = id ? `${baseUrl}api/expenses/${id}` : `${baseUrl}api/expenses`;
        const method = id ? "PUT" : "POST";

        fetch(url, {
            method: method,
            headers: {
                "Authorization": `Bearer ${token}`,
                "Content-Type": "application/json"
            },
            body: JSON.stringify(payload)
        })
        .then(res => res.json())
        .then(() => {
            Swal.fire(id ? "Updated!" : "Created!", `Expense ${id ? "updated" : "created"} successfully.`, "success");
            bootstrap.Modal.getInstance(document.getElementById("expenseModal")).hide();
            fetchExpenses();
        }).catch(() => {
            Swal.fire("Error", "Something went wrong.", "error");
        });
    });
    fetchExpenses();
    fetchAssets();
    fetchExpenseType();
    fetchReports();
});
</script>
@endsection
