@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Expense Types</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Expense Types</li>
            </ol>
        </nav>
    </div>

    <section class="section dashboard">
        <div class="container">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <input type="text" id="searchInput" class="form-control w-50" placeholder="Search expense types...">
                    <a href="{{ route('expense-types.create') }}" class="btn btn-primary">Add New Expense Type</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="expenseTypesTable">
                            <thead>
                                <tr>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Description</th>
                                    <th>Component</th>
                                    <th>Created By</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Edit Modal -->
    <div class="modal fade" id="editExpenseTypeModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="editExpenseTypeForm" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Expense Type</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="editExpenseTypeId">
                    
                    <div class="mb-3">
                        <label class="form-label">Code</label>
                        <input type="text" class="form-control" id="editExpenseTypeCode" readonly>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" id="editExpenseTypeName" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" id="editExpenseTypeDescription"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Component</label>
                        <div class="card bg-light p-2">
                            <span id="editExpenseTypeComponentName" class="fw-bold text-primary"></span>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" id="editExpenseTypeStatus">
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const token = localStorage.getItem("token");
    const tbody = document.querySelector("#expenseTypesTable tbody");

    function fetchExpenseTypes() {
        fetch({{ env('APP_URL') . 'api/expense-types'}}, {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            tbody.innerHTML = data.map(et => `
                <tr>
                    <td>${et.code}</td>
                    <td>${et.name}</td>
                    <td>${et.description || "N/A"}</td>
                    <td>${et.component.name}</td>
                    <td>${et.user.name}</td>
                    <td>${et.status ? "Active" : "Inactive"}</td>
                    <td>
                        <button class="btn btn-warning btn-sm edit-btn"
                            data-id="${et.id}" 
                            data-name="${et.name}"
                            data-description="${et.description || ''}" 
                            data-status="${et.status}" 
                            data-code="${et.code}"
                            data-component-name="${et.component.name}"
                            data-component-id="${et.component_id}">
                            Edit
                        </button>
                        <button class="btn btn-danger btn-sm delete-btn" data-id="${et.id}">Delete</button>
                    </td>
                </tr>
            `).join("");
        });
    }

    fetchExpenseTypes();

    // Handle edit click
    tbody.addEventListener("click", e => {
        const target = e.target;

        if (target.classList.contains("edit-btn")) {
            const id = target.getAttribute("data-id");
            const name = target.getAttribute("data-name");
            const code = target.getAttribute("data-code");
            const description = target.getAttribute("data-description");
            const status = target.getAttribute("data-status");
            const componentName = target.getAttribute("data-component-name");

            // Populate modal fields
            document.getElementById("editExpenseTypeId").value = id;
            document.getElementById("editExpenseTypeName").value = name;
            document.getElementById("editExpenseTypeCode").value = code;
            document.getElementById("editExpenseTypeDescription").value = description;
            document.getElementById("editExpenseTypeStatus").value = status;
            document.getElementById("editExpenseTypeComponentName").innerText = componentName;

            new bootstrap.Modal(document.getElementById('editExpenseTypeModal')).show();
        }

        // Handle delete
        if (target.classList.contains("delete-btn")) {
            const id = target.getAttribute("data-id");
            fetch(`${baseUrl}api/expense-types/${id}`, {
                method: "DELETE",
                headers: { "Authorization": `Bearer ${token}` }
            }).then(() => {
                Swal.fire("Deleted!", "Expense Type deleted.", "success");
                fetchExpenseTypes();
            });
        }
    });

    // Handle form submission for editing
    document.getElementById("editExpenseTypeForm").addEventListener("submit", e => {
        e.preventDefault();
        const id = document.getElementById("editExpenseTypeId").value;
        const name = document.getElementById("editExpenseTypeName").value;
        const description = document.getElementById("editExpenseTypeDescription").value;
        const status = document.getElementById("editExpenseTypeStatus").value;

        fetch(`${baseUrl}api/expense-types/${id}`, {
            method: 'PUT',
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ name, description, status })
        }).then(() => {
            Swal.fire('Updated!', 'Expense Type updated successfully.', 'success').then(() => {
                fetchExpenseTypes();
                bootstrap.Modal.getInstance(document.getElementById('editExpenseTypeModal')).hide();
            });
        });
    });
});
</script>
@endsection
