@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Assets</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Assets</li>
            </ol>
        </nav>
    </div>

    <section class="section dashboard">
        <div class="container">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <input type="text" id="searchInput" class="form-control w-50" placeholder="Search assets...">
                    <a href="{{ route('assets.create') }}" class="btn btn-primary">Add New Asset</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="assetsTable">
                            <thead>
                                <tr>
                                    <th>Asset Name</th>
                                    <th>Asset Code</th>
                                    <th>Description</th>
                                    <th>Component Name</th>
                                    <th>Created by</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Edit Modal -->
    <div class="modal fade" id="editAssetModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="editAssetForm">
                        <input type="hidden" id="editAssetId">
                        <div class="mb-3">
                            <label for="editAssetName" class="form-label">Name</label>
                            <input type="text" class="form-control" id="editAssetName" required>
                        </div>
                        <div class="mb-3">
                            <label for="editAssetCode" class="form-label">Asset Code</label>
                            <input type="text" class="form-control" id="editAssetCode" required readonly>
                        </div>
                        <div class="mb-3">
                            <label for="editAssetDescription" class="form-label">Description</label>
                            <textarea class="form-control" id="editAssetDescription"></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="editAssetStatus" class="form-label">Status</label>
                            <select class="form-select" id="editAssetStatus">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-success">Save Changes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteAssetModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this asset?</p>
                    <input type="hidden" id="deleteAssetId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteAssetBtn">Delete</button>
                </div>
            </div>
        </div>
    </div>
</main>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const token = localStorage.getItem("token");
    const user = JSON.parse(localStorage.getItem("user"));
    const userId = user ? user.user_id : null;
    const tableBody = document.querySelector("#assetsTable tbody");

    function fetchAssets() {
        fetch({{ env('APP_URL') . 'api/assets'}}, {
            headers: { "Authorization": `Bearer ${token}` }
        })
        .then(res => res.json())
        .then(data => {
            tableBody.innerHTML = data.map(a => `
                <tr>
                    <td>${a.name}</td>
                    <td>${a.code}</td>
                    <td>${a.description || "N/A"}</td>
                    <td>${a.component?.name || "N/A"}</td>
                    <td>${a.user?.name || "N/A"}</td>
                    <td>${a.status ? "Active" : "Inactive"}</td>
                    <td>
                        <button class="btn btn-sm btn-warning edit-btn" data-id="${a.id}" data-name="${a.name}" data-code="${a.code}" data-description="${a.description}" data-status="${a.status}">Edit</button>
                        <button class="btn btn-sm btn-danger delete-btn" data-id="${a.id}">Delete</button>
                    </td>
                </tr>
            `).join("");
        });
    }

    tableBody.addEventListener("click", function(e) {
        const btn = e.target;

        if (btn.classList.contains("edit-btn")) {
            document.getElementById("editAssetId").value = btn.dataset.id;
            document.getElementById("editAssetName").value = btn.dataset.name;
            document.getElementById("editAssetCode").value = btn.dataset.code;
            document.getElementById("editAssetDescription").value = btn.dataset.description;
            document.getElementById("editAssetStatus").value = btn.dataset.status;
            new bootstrap.Modal(document.getElementById("editAssetModal")).show();
        }

        if (btn.classList.contains("delete-btn")) {
            const id = btn.dataset.id;

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(`${baseUrl}api/assets/${id}`, {
                        method: 'DELETE',
                        headers: { 'Authorization': `Bearer ${token}` }
                    }).then(() => {
                        fetchAssets();
                        Swal.fire('Deleted!', 'Asset has been deleted.', 'success');
                    });
                }
            });
        }
    });

    document.getElementById("editAssetForm").addEventListener("submit", function(e) {
        e.preventDefault();
        const id = document.getElementById("editAssetId").value;

        fetch(`${baseUrl}api/assets/${id}`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${token}`
            },
            body: JSON.stringify({
                name: document.getElementById("editAssetName").value,
                code: document.getElementById("editAssetCode").value,
                description: document.getElementById("editAssetDescription").value,
                status: document.getElementById("editAssetStatus").value,
                user_id: userId
            })
        }).then(() => {
            fetchAssets();
            bootstrap.Modal.getInstance(document.getElementById("editAssetModal")).hide();
            Swal.fire('Updated!', 'Asset has been updated successfully.', 'success');
        });
    });

    fetchAssets();
});
</script>

@endsection
