@extends('layouts.main')
<script>
    // Check for token in localStorage
    if (!localStorage.getItem("token")) {
        // Redirect to "/" if token is not found
        window.location.href = "/";
    }
</script>
@section('content')
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Add New Asset</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('assets.index') }}">Assets</a></li>
                <li class="breadcrumb-item active">Add</li>
            </ol>
        </nav>
    </div>

    <section class="section">
        <div class="card">
            <div class="card-body pt-3">
                <form id="addAssetForm">
                    <div class="mb-3">
                        <label for="name" class="form-label">Asset Name</label>
                        <input type="text" class="form-control" id="name" required>
                    </div>
                    <!-- <div class="mb-3">
                        <label for="code" class="form-label">Code</label>
                        <input type="text" class="form-control" id="code" required>
                    </div> -->
                    <div class="mb-3">
                        <label for="component_id" class="form-label">Report Component</label>
                        <select class="form-select" id="component_id"></select>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Create Asset</button>
                </form>
            </div>
        </div>
    </section>
</main>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const token = localStorage.getItem("token");
    const user = JSON.parse(localStorage.getItem("user"));
    const userId = user ? user.user_id : null;

    const componentSelect = document.getElementById("component_id");

    fetch("{{ env('APP_URL') . 'api/report-components'}}", {
        headers: { "Authorization": `Bearer ${token}` }
    })
    .then(res => res.json())
    .then(data => {
        componentSelect.innerHTML = data.map(c =>
            `<option value="${c.id}">${c.name}</option>`
        ).join("");
    });

    document.getElementById("addAssetForm").addEventListener("submit", function (e) {
        e.preventDefault();

        fetch("{{ env('APP_URL') . 'api/assets'}}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${token}`
            },
            body: JSON.stringify({
                name: document.getElementById("name").value,
                // code: document.getElementById("code").value,
                description: document.getElementById("description").value,
                component_id: document.getElementById("component_id").value,
                user_id: userId
            })
        })
        .then(res => res.json())
        .then(() => {
            Swal.fire({
                icon: 'success',
                title: 'Asset Created!',
                text: 'The asset has been added successfully.',
                showConfirmButton: true
            }).then(() => {
                window.location.href = "{{ route('assets.index') }}";
            });
        });
    });
});
</script>

@endsection
