<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('roles', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });

        // Insert default roles
        DB::table('roles')->insert([
            ['name' => 'Admin', 'slug' => 'admin', 'description' => 'System Administrator', 'status' => 1],
            ['name' => 'Manager', 'slug' => 'manager', 'description' => 'Project Manager', 'status' => 1],
            ['name' => 'User', 'slug' => 'user', 'description' => 'Regular User', 'status' => 1],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('roles');
    }
};