<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                if (!Schema::hasColumn('users', 'phone_number')) {
                    $table->string('phone_number')->nullable();
                }
                if (!Schema::hasColumn('users', 'status')) {
                    $table->tinyInteger('status')->default(1);
                }
                if (!Schema::hasColumn('users', 'role_id')) {
                    $table->unsignedBigInteger('role_id');
                }
            });
        }

        if (!Schema::hasTable('report_components')) {
        Schema::create('report_components', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->text('remark')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->unsignedBigInteger('user_id');
            $table->timestamps();
        });
    }
    if (!Schema::hasTable('assets')) {
        Schema::create('assets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('component_id');
            $table->string('name');
            $table->string('code')->unique();
            $table->tinyInteger('status')->default(1);
            $table->text('description')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->timestamps();
        });
    }

    if (!Schema::hasTable('expenses_types')) {
        Schema::create('expenses_types', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('component_id');
            $table->string('name');
            $table->string('code')->unique();
            $table->tinyInteger('status')->default(1);
            $table->text('description')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->timestamps();
        });
    }

    if (!Schema::hasTable('reports')) {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->string('report_number')->unique();
            $table->unsignedBigInteger('asset_id');
            $table->date('start_date');
            $table->date('end_date');
            $table->unsignedBigInteger('user_id');
            $table->timestamps();
        });
    }

    if (!Schema::hasTable('income')) {
        Schema::create('income', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('report_id');
            $table->unsignedBigInteger('asset_id');
            $table->string('income_number')->unique();
            $table->decimal('amount', 15, 2);
            $table->date('date');
            $table->unsignedBigInteger('user_id');
            $table->timestamps();
        });
    }

    if (!Schema::hasTable('expenses')) {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('report_id');
            $table->string('expense_number')->unique();
            $table->unsignedBigInteger('asset_id');
            $table->decimal('amount', 15, 2);
            $table->unsignedBigInteger('expense_type_id');
            $table->unsignedBigInteger('user_id');
            $table->timestamps();
        });
    }
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['phone_number', 'status', 'role_id']);
        });

        Schema::dropIfExists('report_components');
        Schema::dropIfExists('assets');
        Schema::dropIfExists('expenses_types');
        Schema::dropIfExists('reports');
        Schema::dropIfExists('income');
        Schema::dropIfExists('expenses');
    }
};
