<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReportComponent extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'remark',
        'status',
        'user_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function assets()
    {
        return $this->hasMany(Asset::class);
    }

    public function expenseTypes()
    {
        return $this->hasMany(ExpenseType::class);
    }
}