<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExpenseType extends Model
{
    use HasFactory;
    protected $table='expenses_types';
    protected $fillable = [
        'component_id',
        'name',
        'code',
        'status',
        'description',
        'user_id'
    ];

    public function component()
    {
        return $this->belongsTo(ReportComponent::class, 'component_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class);
    }
}