<?php

namespace App\Http\Controllers;

use App\Models\Report;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index()
    {
        $reports = Report::with(['asset', 'user'])->get();
        return response()->json($reports);
    }

    public function store(Request $request)
    {
        $request->validate([
            'asset_id' => 'required|exists:assets,id',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'user_id' => 'required|exists:users,id',
        ]);

        $report = Report::create([
            'report_number' => 'REP-' . uniqid(),
            'asset_id' => $request->asset_id,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'user_id' => $request->user_id
        ]);

        return response()->json($report, 201);
    }

    public function show(Report $report)
    {
        return response()->json($report->load(['asset', 'user', 'income', 'expenses']));
    }

    public function update(Request $request, Report $report)
    {
        $request->validate([
            'asset_id' => 'sometimes|exists:assets,id',
            'start_date' => 'sometimes|date',
            'end_date' => 'sometimes|date|after_or_equal:start_date',
            'user_id' => 'sometimes|exists:users,id',
        ]);

        $report->update($request->all());

        return response()->json($report);
    }

    public function destroy(Report $report)
    {
        $report->delete();
        return response()->json(null, 204);
    }
}