<?php

namespace App\Http\Controllers;

use App\Models\Expense;
use Illuminate\Http\Request;

class ExpenseController extends Controller
{
    public function index()
    {
        $expenses = Expense::with(['report', 'asset', 'expenseType', 'user'])->get();
        return response()->json($expenses);
    }

    public function store(Request $request)
    {
        $request->validate([
            'report_id' => 'required|exists:reports,id',
            'asset_id' => 'required|exists:assets,id',
            'amount' => 'required|numeric|min:0',
            'expense_type_id' => 'required|exists:expenses_types,id',
            'user_id' => 'required|exists:users,id',
        ]);

        $expense = Expense::create([
            'report_id' => $request->report_id,
            'expense_number' => 'EXP-' . uniqid(),
            'asset_id' => $request->asset_id,
            'amount' => $request->amount,
            'expense_type_id' => $request->expense_type_id,
            'user_id' => $request->user_id
        ]);

        return response()->json($expense, 201);
    }

    public function show(Expense $expense)
    {
        return response()->json($expense->load(['report', 'asset', 'expenseType', 'user']));
    }

    public function update(Request $request, Expense $expense)
    {
        $request->validate([
            'report_id' => 'sometimes|exists:reports,id',
            'asset_id' => 'sometimes|exists:assets,id',
            'amount' => 'sometimes|numeric|min:0',
            'expense_type_id' => 'sometimes|exists:expenses_types,id',
            'user_id' => 'sometimes|exists:users,id',
        ]);

        $expense->update($request->all());

        return response()->json($expense);
    }

    public function destroy(Expense $expense)
    {
        $expense->delete();
        return response()->json(null, 204);
    }
}